<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Conversations\V1\Conversation;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class ParticipantOptions {
    /**
     * @param string $identity A unique string identifier for the conversation
     *                         participant as Chat User.
     * @param string $messagingBindingAddress The address of the participant's
     *                                        device.
     * @param string $messagingBindingProxyAddress The address of the Twilio phone
     *                                             number that the participant is
     *                                             in contact with.
     * @param \DateTime $dateCreated The date that this resource was created.
     * @param \DateTime $dateUpdated The date that this resource was last updated.
     * @param string $attributes An optional string metadata field you can use to
     *                           store any data you wish.
     * @param string $messagingBindingProjectedAddress The address of the Twilio
     *                                                 phone number that is used in
     *                                                 Group MMS.
     * @param string $roleSid The SID of the Role to assign to the participant
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP
     *                                      request header
     * @return CreateParticipantOptions Options builder
     */
    public static function create(string $identity = Values::NONE, string $messagingBindingAddress = Values::NONE, string $messagingBindingProxyAddress = Values::NONE, \DateTime $dateCreated = Values::NONE, \DateTime $dateUpdated = Values::NONE, string $attributes = Values::NONE, string $messagingBindingProjectedAddress = Values::NONE, string $roleSid = Values::NONE, string $xTwilioWebhookEnabled = Values::NONE): CreateParticipantOptions {
        return new CreateParticipantOptions($identity, $messagingBindingAddress, $messagingBindingProxyAddress, $dateCreated, $dateUpdated, $attributes, $messagingBindingProjectedAddress, $roleSid, $xTwilioWebhookEnabled);
    }

    /**
     * @param \DateTime $dateCreated The date that this resource was created.
     * @param \DateTime $dateUpdated The date that this resource was last updated.
     * @param string $attributes An optional string metadata field you can use to
     *                           store any data you wish.
     * @param string $roleSid The SID of the Role to assign to the participant
     * @param string $messagingBindingProxyAddress The address of the Twilio phone
     *                                             number that the participant is
     *                                             in contact with.
     * @param string $messagingBindingProjectedAddress The address of the Twilio
     *                                                 phone number that is used in
     *                                                 Group MMS.
     * @param string $identity A unique string identifier for the conversation
     *                         participant as Chat User.
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP
     *                                      request header
     * @return UpdateParticipantOptions Options builder
     */
    public static function update(\DateTime $dateCreated = Values::NONE, \DateTime $dateUpdated = Values::NONE, string $attributes = Values::NONE, string $roleSid = Values::NONE, string $messagingBindingProxyAddress = Values::NONE, string $messagingBindingProjectedAddress = Values::NONE, string $identity = Values::NONE, string $xTwilioWebhookEnabled = Values::NONE): UpdateParticipantOptions {
        return new UpdateParticipantOptions($dateCreated, $dateUpdated, $attributes, $roleSid, $messagingBindingProxyAddress, $messagingBindingProjectedAddress, $identity, $xTwilioWebhookEnabled);
    }

    /**
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP
     *                                      request header
     * @return DeleteParticipantOptions Options builder
     */
    public static function delete(string $xTwilioWebhookEnabled = Values::NONE): DeleteParticipantOptions {
        return new DeleteParticipantOptions($xTwilioWebhookEnabled);
    }
}

class CreateParticipantOptions extends Options {
    /**
     * @param string $identity A unique string identifier for the conversation
     *                         participant as Chat User.
     * @param string $messagingBindingAddress The address of the participant's
     *                                        device.
     * @param string $messagingBindingProxyAddress The address of the Twilio phone
     *                                             number that the participant is
     *                                             in contact with.
     * @param \DateTime $dateCreated The date that this resource was created.
     * @param \DateTime $dateUpdated The date that this resource was last updated.
     * @param string $attributes An optional string metadata field you can use to
     *                           store any data you wish.
     * @param string $messagingBindingProjectedAddress The address of the Twilio
     *                                                 phone number that is used in
     *                                                 Group MMS.
     * @param string $roleSid The SID of the Role to assign to the participant
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP
     *                                      request header
     */
    public function __construct(string $identity = Values::NONE, string $messagingBindingAddress = Values::NONE, string $messagingBindingProxyAddress = Values::NONE, \DateTime $dateCreated = Values::NONE, \DateTime $dateUpdated = Values::NONE, string $attributes = Values::NONE, string $messagingBindingProjectedAddress = Values::NONE, string $roleSid = Values::NONE, string $xTwilioWebhookEnabled = Values::NONE) {
        $this->options['identity'] = $identity;
        $this->options['messagingBindingAddress'] = $messagingBindingAddress;
        $this->options['messagingBindingProxyAddress'] = $messagingBindingProxyAddress;
        $this->options['dateCreated'] = $dateCreated;
        $this->options['dateUpdated'] = $dateUpdated;
        $this->options['attributes'] = $attributes;
        $this->options['messagingBindingProjectedAddress'] = $messagingBindingProjectedAddress;
        $this->options['roleSid'] = $roleSid;
        $this->options['xTwilioWebhookEnabled'] = $xTwilioWebhookEnabled;
    }

    /**
     * A unique string identifier for the conversation participant as [Chat User](https://www.twilio.com/docs/chat/rest/user-resource). This parameter is non-null if (and only if) the participant is using the Programmable Chat SDK to communicate. Limited to 256 characters.
     *
     * @param string $identity A unique string identifier for the conversation
     *                         participant as Chat User.
     * @return $this Fluent Builder
     */
    public function setIdentity(string $identity): self {
        $this->options['identity'] = $identity;
        return $this;
    }

    /**
     * The address of the participant's device, e.g. a phone number or Messenger ID. Together with the Proxy address, this determines a participant uniquely. This field (with proxy_address) is only null when the participant is interacting from a Chat endpoint (see the 'identity' field).
     *
     * @param string $messagingBindingAddress The address of the participant's
     *                                        device.
     * @return $this Fluent Builder
     */
    public function setMessagingBindingAddress(string $messagingBindingAddress): self {
        $this->options['messagingBindingAddress'] = $messagingBindingAddress;
        return $this;
    }

    /**
     * The address of the Twilio phone number (or WhatsApp number, or Messenger Page ID) that the participant is in contact with. This field, together with participant address, is only null when the participant is interacting from a Chat endpoint (see the 'identity' field).
     *
     * @param string $messagingBindingProxyAddress The address of the Twilio phone
     *                                             number that the participant is
     *                                             in contact with.
     * @return $this Fluent Builder
     */
    public function setMessagingBindingProxyAddress(string $messagingBindingProxyAddress): self {
        $this->options['messagingBindingProxyAddress'] = $messagingBindingProxyAddress;
        return $this;
    }

    /**
     * The date that this resource was created.
     *
     * @param \DateTime $dateCreated The date that this resource was created.
     * @return $this Fluent Builder
     */
    public function setDateCreated(\DateTime $dateCreated): self {
        $this->options['dateCreated'] = $dateCreated;
        return $this;
    }

    /**
     * The date that this resource was last updated.
     *
     * @param \DateTime $dateUpdated The date that this resource was last updated.
     * @return $this Fluent Builder
     */
    public function setDateUpdated(\DateTime $dateUpdated): self {
        $this->options['dateUpdated'] = $dateUpdated;
        return $this;
    }

    /**
     * An optional string metadata field you can use to store any data you wish. The string value must contain structurally valid JSON if specified.  **Note** that if the attributes are not set "{}" will be returned.
     *
     * @param string $attributes An optional string metadata field you can use to
     *                           store any data you wish.
     * @return $this Fluent Builder
     */
    public function setAttributes(string $attributes): self {
        $this->options['attributes'] = $attributes;
        return $this;
    }

    /**
     * The address of the Twilio phone number that is used in Group MMS. Communication mask for the Chat participant with Identity.
     *
     * @param string $messagingBindingProjectedAddress The address of the Twilio
     *                                                 phone number that is used in
     *                                                 Group MMS.
     * @return $this Fluent Builder
     */
    public function setMessagingBindingProjectedAddress(string $messagingBindingProjectedAddress): self {
        $this->options['messagingBindingProjectedAddress'] = $messagingBindingProjectedAddress;
        return $this;
    }

    /**
     * The SID of the [Role](https://www.twilio.com/docs/chat/rest/role-resource) to assign to the participant.
     *
     * @param string $roleSid The SID of the Role to assign to the participant
     * @return $this Fluent Builder
     */
    public function setRoleSid(string $roleSid): self {
        $this->options['roleSid'] = $roleSid;
        return $this;
    }

    /**
     * The X-Twilio-Webhook-Enabled HTTP request header
     *
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP
     *                                      request header
     * @return $this Fluent Builder
     */
    public function setXTwilioWebhookEnabled(string $xTwilioWebhookEnabled): self {
        $this->options['xTwilioWebhookEnabled'] = $xTwilioWebhookEnabled;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Conversations.V1.CreateParticipantOptions ' . $options . ']';
    }
}

class UpdateParticipantOptions extends Options {
    /**
     * @param \DateTime $dateCreated The date that this resource was created.
     * @param \DateTime $dateUpdated The date that this resource was last updated.
     * @param string $attributes An optional string metadata field you can use to
     *                           store any data you wish.
     * @param string $roleSid The SID of the Role to assign to the participant
     * @param string $messagingBindingProxyAddress The address of the Twilio phone
     *                                             number that the participant is
     *                                             in contact with.
     * @param string $messagingBindingProjectedAddress The address of the Twilio
     *                                                 phone number that is used in
     *                                                 Group MMS.
     * @param string $identity A unique string identifier for the conversation
     *                         participant as Chat User.
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP
     *                                      request header
     */
    public function __construct(\DateTime $dateCreated = Values::NONE, \DateTime $dateUpdated = Values::NONE, string $attributes = Values::NONE, string $roleSid = Values::NONE, string $messagingBindingProxyAddress = Values::NONE, string $messagingBindingProjectedAddress = Values::NONE, string $identity = Values::NONE, string $xTwilioWebhookEnabled = Values::NONE) {
        $this->options['dateCreated'] = $dateCreated;
        $this->options['dateUpdated'] = $dateUpdated;
        $this->options['attributes'] = $attributes;
        $this->options['roleSid'] = $roleSid;
        $this->options['messagingBindingProxyAddress'] = $messagingBindingProxyAddress;
        $this->options['messagingBindingProjectedAddress'] = $messagingBindingProjectedAddress;
        $this->options['identity'] = $identity;
        $this->options['xTwilioWebhookEnabled'] = $xTwilioWebhookEnabled;
    }

    /**
     * The date that this resource was created.
     *
     * @param \DateTime $dateCreated The date that this resource was created.
     * @return $this Fluent Builder
     */
    public function setDateCreated(\DateTime $dateCreated): self {
        $this->options['dateCreated'] = $dateCreated;
        return $this;
    }

    /**
     * The date that this resource was last updated.
     *
     * @param \DateTime $dateUpdated The date that this resource was last updated.
     * @return $this Fluent Builder
     */
    public function setDateUpdated(\DateTime $dateUpdated): self {
        $this->options['dateUpdated'] = $dateUpdated;
        return $this;
    }

    /**
     * An optional string metadata field you can use to store any data you wish. The string value must contain structurally valid JSON if specified.  **Note** that if the attributes are not set "{}" will be returned.
     *
     * @param string $attributes An optional string metadata field you can use to
     *                           store any data you wish.
     * @return $this Fluent Builder
     */
    public function setAttributes(string $attributes): self {
        $this->options['attributes'] = $attributes;
        return $this;
    }

    /**
     * The SID of the [Role](https://www.twilio.com/docs/chat/rest/role-resource) to assign to the participant.
     *
     * @param string $roleSid The SID of the Role to assign to the participant
     * @return $this Fluent Builder
     */
    public function setRoleSid(string $roleSid): self {
        $this->options['roleSid'] = $roleSid;
        return $this;
    }

    /**
     * The address of the Twilio phone number that the participant is in contact with. 'null' value will remove it.
     *
     * @param string $messagingBindingProxyAddress The address of the Twilio phone
     *                                             number that the participant is
     *                                             in contact with.
     * @return $this Fluent Builder
     */
    public function setMessagingBindingProxyAddress(string $messagingBindingProxyAddress): self {
        $this->options['messagingBindingProxyAddress'] = $messagingBindingProxyAddress;
        return $this;
    }

    /**
     * The address of the Twilio phone number that is used in Group MMS. 'null' value will remove it.
     *
     * @param string $messagingBindingProjectedAddress The address of the Twilio
     *                                                 phone number that is used in
     *                                                 Group MMS.
     * @return $this Fluent Builder
     */
    public function setMessagingBindingProjectedAddress(string $messagingBindingProjectedAddress): self {
        $this->options['messagingBindingProjectedAddress'] = $messagingBindingProjectedAddress;
        return $this;
    }

    /**
     * A unique string identifier for the conversation participant as [Chat User](https://www.twilio.com/docs/chat/rest/user-resource). This parameter is non-null if (and only if) the participant is using the Programmable Chat SDK to communicate. Limited to 256 characters.
     *
     * @param string $identity A unique string identifier for the conversation
     *                         participant as Chat User.
     * @return $this Fluent Builder
     */
    public function setIdentity(string $identity): self {
        $this->options['identity'] = $identity;
        return $this;
    }

    /**
     * The X-Twilio-Webhook-Enabled HTTP request header
     *
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP
     *                                      request header
     * @return $this Fluent Builder
     */
    public function setXTwilioWebhookEnabled(string $xTwilioWebhookEnabled): self {
        $this->options['xTwilioWebhookEnabled'] = $xTwilioWebhookEnabled;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Conversations.V1.UpdateParticipantOptions ' . $options . ']';
    }
}

class DeleteParticipantOptions extends Options {
    /**
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP
     *                                      request header
     */
    public function __construct(string $xTwilioWebhookEnabled = Values::NONE) {
        $this->options['xTwilioWebhookEnabled'] = $xTwilioWebhookEnabled;
    }

    /**
     * The X-Twilio-Webhook-Enabled HTTP request header
     *
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP
     *                                      request header
     * @return $this Fluent Builder
     */
    public function setXTwilioWebhookEnabled(string $xTwilioWebhookEnabled): self {
        $this->options['xTwilioWebhookEnabled'] = $xTwilioWebhookEnabled;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Conversations.V1.DeleteParticipantOptions ' . $options . ']';
    }
}